<?php 
/**
 * Tagihansiswapin_arsip Page Controller
 * @category  Controller
 */
class Tagihansiswapin_arsipController extends SecureController{
	function __construct(){
		parent::__construct();
		$this->tablename = "tagihansiswapin_arsip";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("idtagih", 
			"tahun", 
			"nis", 
			"nama", 
			"kelas", 
			"status", 
			"jenisbayar", 
			"tagihan", 
			"statusverifikasi");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				tagihansiswapin_arsip.idtagih LIKE ? OR 
				tagihansiswapin_arsip.tahun LIKE ? OR 
				tagihansiswapin_arsip.nis LIKE ? OR 
				tagihansiswapin_arsip.nama LIKE ? OR 
				tagihansiswapin_arsip.kelas LIKE ? OR 
				tagihansiswapin_arsip.status LIKE ? OR 
				tagihansiswapin_arsip.jenisbayar LIKE ? OR 
				tagihansiswapin_arsip.tagihan LIKE ? OR 
				tagihansiswapin_arsip.bayar LIKE ? OR 
				tagihansiswapin_arsip.sisa_bayar LIKE ? OR 
				tagihansiswapin_arsip.statusverifikasi LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "tagihansiswapin_arsip/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("tagihansiswapin_arsip.idtagih", ORDER_TYPE);
		}
		$db->where("tagihansiswapin_arsip.nis", get_active_user('user') );
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Tagihansiswapin Arsip";
		$this->view->report_filename = date('Y-m-d') . '-' . $page_title;
		$this->view->report_title = $page_title;
		$this->view->report_layout = "report_layout.php";
		$this->view->report_paper_size = "A4";
		$this->view->report_orientation = "portrait";
		$this->render_view("tagihansiswapin_arsip/list.php", $data); //render the full page
	}
// No View Function Generated Because No Field is Defined as the Primary Key on the Database Table
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("idtagih","tahun","nis","nama","kelas","status","jenisbayar","tagihan","bayar","sisa_bayar","statusverifikasi");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'idtagih' => 'required|numeric',
				'tahun' => 'required',
				'nis' => 'required|numeric',
				'nama' => 'required',
				'kelas' => 'required',
				'status' => 'required',
				'jenisbayar' => 'required',
				'tagihan' => 'required|numeric',
				'bayar' => 'required|numeric',
				'sisa_bayar' => 'required|numeric',
				'statusverifikasi' => 'required',
			);
			$this->sanitize_array = array(
				'idtagih' => 'sanitize_string',
				'tahun' => 'sanitize_string',
				'nis' => 'sanitize_string',
				'nama' => 'sanitize_string',
				'kelas' => 'sanitize_string',
				'status' => 'sanitize_string',
				'jenisbayar' => 'sanitize_string',
				'tagihan' => 'sanitize_string',
				'bayar' => 'sanitize_string',
				'sisa_bayar' => 'sanitize_string',
				'statusverifikasi' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("tagihansiswapin_arsip");
				}
				else{
					$this->set_page_error();
				}
			}
		}
		$page_title = $this->view->page_title = "Add New Tagihansiswapin Arsip";
		$this->render_view("tagihansiswapin_arsip/add.php");
	}
// No Edit Function Generated Because No Field is Defined as the Primary Key
// No Delete Function Generated Because No Field is Defined as the Primary Key on the Database Table/View
}
