<?php 
/**
 * Tagihan_sipin Page Controller
 * @category  Controller
 */
class Tagihan_sipinController extends SecureController{
	function __construct(){
		parent::__construct();
		$this->tablename = "tagihan_sipin";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("idtagih", 
			"tahun", 
			"nis", 
			"nama", 
			"kelas", 
			"status", 
			"du", 
			"usganjil", 
			"usgenap", 
			"umad", 
			"lain", 
			"jul", 
			"agt", 
			"sep", 
			"okt", 
			"nov", 
			"des", 
			"jan", 
			"feb", 
			"mar", 
			"apr", 
			"mei", 
			"jun", 
			"tanggal", 
			"total");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				tagihan_sipin.idtagih LIKE ? OR 
				tagihan_sipin.tahun LIKE ? OR 
				tagihan_sipin.nis LIKE ? OR 
				tagihan_sipin.nama LIKE ? OR 
				tagihan_sipin.kelas LIKE ? OR 
				tagihan_sipin.status LIKE ? OR 
				tagihan_sipin.du LIKE ? OR 
				tagihan_sipin.usganjil LIKE ? OR 
				tagihan_sipin.usgenap LIKE ? OR 
				tagihan_sipin.umad LIKE ? OR 
				tagihan_sipin.lain LIKE ? OR 
				tagihan_sipin.jul LIKE ? OR 
				tagihan_sipin.agt LIKE ? OR 
				tagihan_sipin.sep LIKE ? OR 
				tagihan_sipin.okt LIKE ? OR 
				tagihan_sipin.nov LIKE ? OR 
				tagihan_sipin.des LIKE ? OR 
				tagihan_sipin.jan LIKE ? OR 
				tagihan_sipin.feb LIKE ? OR 
				tagihan_sipin.mar LIKE ? OR 
				tagihan_sipin.apr LIKE ? OR 
				tagihan_sipin.mei LIKE ? OR 
				tagihan_sipin.jun LIKE ? OR 
				tagihan_sipin.tanggal LIKE ? OR 
				tagihan_sipin.total LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "tagihan_sipin/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("tagihan_sipin.idtagih", ORDER_TYPE);
		}
		$db->where("tagihan_sipin.nis", get_active_user('user') );
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Tagihan Sipin";
		$this->view->report_filename = date('Y-m-d') . '-' . $page_title;
		$this->view->report_title = $page_title;
		$this->view->report_layout = "report_layout.php";
		$this->view->report_paper_size = "A4";
		$this->view->report_orientation = "portrait";
		$this->render_view("tagihan_sipin/list.php", $data); //render the full page
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("idtagih", 
			"tahun", 
			"nis", 
			"nama", 
			"kelas", 
			"status", 
			"du", 
			"usganjil", 
			"usgenap", 
			"umad", 
			"lain", 
			"jul", 
			"agt", 
			"sep", 
			"okt", 
			"nov", 
			"des", 
			"jan", 
			"feb", 
			"mar", 
			"apr", 
			"mei", 
			"jun", 
			"tanggal", 
			"total");
		$db->where("tagihan_sipin.nis", get_active_user('user') );
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("tagihan_sipin.idtagih", $rec_id);; //select record based on primary key
		}
		$record = $db->getOne($tablename, $fields );
		if($record){
			$page_title = $this->view->page_title = "View  Tagihan Sipin";
		$this->view->report_filename = date('Y-m-d') . '-' . $page_title;
		$this->view->report_title = $page_title;
		$this->view->report_layout = "report_layout.php";
		$this->view->report_paper_size = "A4";
		$this->view->report_orientation = "portrait";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
		}
		return $this->render_view("tagihan_sipin/view.php", $record);
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("tahun","nis","nama","kelas","status","du","usganjil","usgenap","umad","lain","jul","agt","sep","okt","nov","des","jan","feb","mar","apr","mei","jun","tanggal","total");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'tahun' => 'required',
				'nis' => 'required|numeric',
				'nama' => 'required',
				'kelas' => 'required',
				'status' => 'required',
				'du' => 'required|numeric',
				'usganjil' => 'required|numeric',
				'usgenap' => 'required|numeric',
				'umad' => 'required|numeric',
				'lain' => 'required|numeric',
				'jul' => 'required|numeric',
				'agt' => 'required|numeric',
				'sep' => 'required|numeric',
				'okt' => 'required|numeric',
				'nov' => 'required|numeric',
				'des' => 'required|numeric',
				'jan' => 'required|numeric',
				'feb' => 'required|numeric',
				'mar' => 'required|numeric',
				'apr' => 'required|numeric',
				'mei' => 'required|numeric',
				'jun' => 'required|numeric',
				'tanggal' => 'required',
				'total' => 'required|numeric',
			);
			$this->sanitize_array = array(
				'tahun' => 'sanitize_string',
				'nis' => 'sanitize_string',
				'nama' => 'sanitize_string',
				'kelas' => 'sanitize_string',
				'status' => 'sanitize_string',
				'du' => 'sanitize_string',
				'usganjil' => 'sanitize_string',
				'usgenap' => 'sanitize_string',
				'umad' => 'sanitize_string',
				'lain' => 'sanitize_string',
				'jul' => 'sanitize_string',
				'agt' => 'sanitize_string',
				'sep' => 'sanitize_string',
				'okt' => 'sanitize_string',
				'nov' => 'sanitize_string',
				'des' => 'sanitize_string',
				'jan' => 'sanitize_string',
				'feb' => 'sanitize_string',
				'mar' => 'sanitize_string',
				'apr' => 'sanitize_string',
				'mei' => 'sanitize_string',
				'jun' => 'sanitize_string',
				'tanggal' => 'sanitize_string',
				'total' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("tagihan_sipin");
				}
				else{
					$this->set_page_error();
				}
			}
		}
		$page_title = $this->view->page_title = "Add New Tagihan Sipin";
		$this->render_view("tagihan_sipin/add.php");
	}
	/**
     * Update table record with formdata
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function edit($rec_id = null, $formdata = null){
		$request = $this->request;
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		 //editable fields
		$fields = $this->fields = array("idtagih","tahun","nis","nama","kelas","status","du","usganjil","usgenap","umad","lain","jul","agt","sep","okt","nov","des","jan","feb","mar","apr","mei","jun","tanggal","total");
		if($formdata){
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'tahun' => 'required',
				'nis' => 'required|numeric',
				'nama' => 'required',
				'kelas' => 'required',
				'status' => 'required',
				'du' => 'required|numeric',
				'usganjil' => 'required|numeric',
				'usgenap' => 'required|numeric',
				'umad' => 'required|numeric',
				'lain' => 'required|numeric',
				'jul' => 'required|numeric',
				'agt' => 'required|numeric',
				'sep' => 'required|numeric',
				'okt' => 'required|numeric',
				'nov' => 'required|numeric',
				'des' => 'required|numeric',
				'jan' => 'required|numeric',
				'feb' => 'required|numeric',
				'mar' => 'required|numeric',
				'apr' => 'required|numeric',
				'mei' => 'required|numeric',
				'jun' => 'required|numeric',
				'tanggal' => 'required',
				'total' => 'required|numeric',
			);
			$this->sanitize_array = array(
				'tahun' => 'sanitize_string',
				'nis' => 'sanitize_string',
				'nama' => 'sanitize_string',
				'kelas' => 'sanitize_string',
				'status' => 'sanitize_string',
				'du' => 'sanitize_string',
				'usganjil' => 'sanitize_string',
				'usgenap' => 'sanitize_string',
				'umad' => 'sanitize_string',
				'lain' => 'sanitize_string',
				'jul' => 'sanitize_string',
				'agt' => 'sanitize_string',
				'sep' => 'sanitize_string',
				'okt' => 'sanitize_string',
				'nov' => 'sanitize_string',
				'des' => 'sanitize_string',
				'jan' => 'sanitize_string',
				'feb' => 'sanitize_string',
				'mar' => 'sanitize_string',
				'apr' => 'sanitize_string',
				'mei' => 'sanitize_string',
				'jun' => 'sanitize_string',
				'tanggal' => 'sanitize_string',
				'total' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
		$db->where("tagihan_sipin.nis", get_active_user('user') );
				$db->where("tagihan_sipin.idtagih", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					$this->set_flash_msg("Record updated successfully", "success");
					return $this->redirect("tagihan_sipin");
				}
				else{
					if($db->getLastError()){
						$this->set_page_error();
					}
					elseif(!$numRows){
						//not an error, but no record was updated
						$page_error = "No record updated";
						$this->set_page_error($page_error);
						$this->set_flash_msg($page_error, "warning");
						return	$this->redirect("tagihan_sipin");
					}
				}
			}
		}
		$db->where("tagihan_sipin.nis", get_active_user('user') );$db->where("tagihan_sipin.idtagih", $rec_id);;
		$data = $db->getOne($tablename, $fields);
		$page_title = $this->view->page_title = "Edit  Tagihan Sipin";
		if(!$data){
			$this->set_page_error();
		}
		return $this->render_view("tagihan_sipin/edit.php", $data);
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("idtagih","tahun","nis","nama","kelas","status","du","usganjil","usgenap","umad","lain","jul","agt","sep","okt","nov","des","jan","feb","mar","apr","mei","jun","tanggal","total");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'tahun' => 'required',
				'nis' => 'required|numeric',
				'nama' => 'required',
				'kelas' => 'required',
				'status' => 'required',
				'du' => 'required|numeric',
				'usganjil' => 'required|numeric',
				'usgenap' => 'required|numeric',
				'umad' => 'required|numeric',
				'lain' => 'required|numeric',
				'jul' => 'required|numeric',
				'agt' => 'required|numeric',
				'sep' => 'required|numeric',
				'okt' => 'required|numeric',
				'nov' => 'required|numeric',
				'des' => 'required|numeric',
				'jan' => 'required|numeric',
				'feb' => 'required|numeric',
				'mar' => 'required|numeric',
				'apr' => 'required|numeric',
				'mei' => 'required|numeric',
				'jun' => 'required|numeric',
				'tanggal' => 'required',
				'total' => 'required|numeric',
			);
			$this->sanitize_array = array(
				'tahun' => 'sanitize_string',
				'nis' => 'sanitize_string',
				'nama' => 'sanitize_string',
				'kelas' => 'sanitize_string',
				'status' => 'sanitize_string',
				'du' => 'sanitize_string',
				'usganjil' => 'sanitize_string',
				'usgenap' => 'sanitize_string',
				'umad' => 'sanitize_string',
				'lain' => 'sanitize_string',
				'jul' => 'sanitize_string',
				'agt' => 'sanitize_string',
				'sep' => 'sanitize_string',
				'okt' => 'sanitize_string',
				'nov' => 'sanitize_string',
				'des' => 'sanitize_string',
				'jan' => 'sanitize_string',
				'feb' => 'sanitize_string',
				'mar' => 'sanitize_string',
				'apr' => 'sanitize_string',
				'mei' => 'sanitize_string',
				'jun' => 'sanitize_string',
				'tanggal' => 'sanitize_string',
				'total' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
		$db->where("tagihan_sipin.nis", get_active_user('user') );
				$db->where("tagihan_sipin.idtagih", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
	/**
     * Delete record from the database
	 * Support multi delete by separating record id by comma.
     * @return BaseView
     */
	function delete($rec_id = null){
		Csrf::cross_check();
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$this->rec_id = $rec_id;
		//form multiple delete, split record id separated by comma into array
		$arr_rec_id = array_map('trim', explode(",", $rec_id));
		$db->where("tagihan_sipin.idtagih", $arr_rec_id, "in");
		$db->where("tagihan_sipin.nis", get_active_user('user') );
		$bool = $db->delete($tablename);
		if($bool){
			$this->set_flash_msg("Record deleted successfully", "success");
		}
		elseif($db->getLastError()){
			$page_error = $db->getLastError();
			$this->set_flash_msg($page_error, "danger");
		}
		return	$this->redirect("tagihan_sipin");
	}
}
